﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml;
using System.Windows.Forms;
using System.IO;

namespace RevisionAnalyser.Global
{
    public class GlobalVariables
    {
        private static GlobalVariables _instance;
        public static GlobalVariables Instance
        {
            get
            {
                if (_instance == null)
                {
                    _instance = new GlobalVariables();
                }
                return _instance;
            }
        }

        private string _file;
        private XmlDocument _xmlDocument = new XmlDocument();

        public GlobalVariables()
        {
            _file = Environment.GetFolderPath(Environment.SpecialFolder.CommonApplicationData) + "\\Revision Analyser\\GlobalVars.xml";
            if (File.Exists(_file))
            {
                _xmlDocument.Load(_file);
            }
            else
            {
                XmlNode root = _xmlDocument.CreateElement("GlobalVars");
                _xmlDocument.AppendChild(root);
            }
        }

        public Dictionary<string, string> GetVariables()
        {
            Dictionary<string, string> vars = new Dictionary<string, string>();
            foreach (XmlNode node in _xmlDocument.SelectSingleNode("/*").ChildNodes)
            {
                vars.Add(node.Name, node.InnerText);
            }
            return vars;
        }

        public string GetVariable(string key, string defaultValue)
        {
            XmlNode node = _xmlDocument.SelectSingleNode("./GlobalVars/" + key);
            if (node == null)
            {
                GlobalVariableForm frmGlobalVariable = new GlobalVariableForm(String.Format("The global variable '{0}' is not yet configured. Please enter a value for it below.", key), key, defaultValue, true, false);
                frmGlobalVariable.ShowDialog();
                SetVariable(key, frmGlobalVariable.GetValue());
                return frmGlobalVariable.GetValue();
            }
            else
            {
                return node.InnerText;
            }
        }

        public string GetVariable(string key)
        {
            return GetVariable(key, string.Empty);
        }

        public void SetVariable(string key, string value)
        {
            key = key.ToUpper();
            XmlNode node = _xmlDocument.SelectSingleNode("./GlobalVars/" + key);
            if (node == null)
            {
                XmlElement newNode = _xmlDocument.CreateElement(key);
                newNode.InnerText = value;
                _xmlDocument.SelectSingleNode("/*").AppendChild(newNode);
            }
            else
            {
                node.InnerText = value;
            }
            _xmlDocument.Save(_file);
        }

        public void DeleteVariable(string key)
        {
            key = key.ToUpper();
            XmlNode node = _xmlDocument.SelectSingleNode("./GlobalVars/" + key);
            if (node != null)
            {
                _xmlDocument.SelectSingleNode("/*").RemoveChild(node);
                _xmlDocument.Save(_file);
            }
        }

        public void DeleteVariables()
        {
            XmlNode node = _xmlDocument.SelectSingleNode("./GlobalVars");
            if (node != null)
            {
                node.RemoveAll();
                _xmlDocument.Save(_file);
            }
        }
    }
}
